/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
 * File name     : mini_api.h
 ************************************************************************
 * Written by    : Joerg Weedermann, BID R&D, 18.1.96
 * Last modified : 3.4.96
 ************************************************************************
 * File contents :
 *                 own type definitions, function headers
 ************************************************************************
 * NOTES :
 ************************************************************************
 */

#ifndef MINI_API_H_INCLUDED
#define MINI_API_H_INCLUDED

/* this contains the typedefinitions and some necessary defines */
#include <typedefs.h>


/* function declarations are here */
#include <board.h>
#include <builtin.h>
#include <compact.h>
#include <confscan.h>
#include <cpuport.h>
#include <decode.h>
#include <dynamic.h>
#include <host.h>
#include <ladata.h>
#include <latrig.h>
#include <master.h>
#include <observer.h>
#include <perfseq.h>
#include <rapidfw.h>
#include <session.h>
#include <target.h>
#include <timcheck.h>
#include <trigio.h>

/* capi helper functions */
#include <errcapi.h>
#include <iocommon.h>
#include <version.h>

#include <mailbox.h>

#ifdef __cplusplus
extern "C" {
#endif
  
/* the following typedef is for compatibility with the MS Compiler */
typedef char * MS_STR;
  
/* -----------------------------------------------------------------
 * Best PME Register Functions 
 * ----------------------------------------------------------------- */
    

CLI b_errtype EXPORT BestPMEWrite(                                 /* @pmewrite */
           b_handletype handle,
           b_int32      value              /* @val */
                                   );
CLI b_errtype EXPORT BestPMERead(                                  /* @pmeread */
               b_handletype handle,
         b_int32      *value_ptr           /* #RETURN "value  =: %08lx\\h\n" */
                                 );


/* -----------------------------------------------------------------
 * Interrupt Generation Functions 
 * ----------------------------------------------------------------- */

CLI b_errtype EXPORT BestInterruptGenerate(                         /* @intgen */
             b_handletype handle,
             b_int32      pci_int     /* @int */
             );



/* -----------------------------------------------------------------
 * Mailbox Register Functions 
 * ----------------------------------------------------------------- */

CLI b_errtype EXPORT  BestMailboxSendRegWrite(                      /* @msregwrite */
                b_handletype handle,
                b_int32      value,   /* @val */
                b_int32      *status  /* #RETURN "status =: %x\\h\n" */
                );

CLI b_errtype EXPORT  BestMailboxReceiveRegRead(                      /* @mrregread */
            b_handletype handle,
            b_int32      *value,  /* #RETURN "value  =: %02lx\\h\n" */
            b_int32      *status  /* #RETURN "status =: %x\\h\n"    */
            );

/* PCICfg functions moved to mailbox.h */


/* -----------------------------------------------------------------
 * Hex Dixplay Functions 
 * ----------------------------------------------------------------- */

CLI b_errtype EXPORT BestDisplayPropSet(                      /* @dprpset */
          b_handletype handle,
          b_int32      value    /* @val */
          );


CLI b_errtype EXPORT BestDisplayWrite(                        /* @dwrite */
              b_handletype handle,
              b_int32      value      /* @val */ 
              );



/* -----------------------------------------------------------------
 * Power Up Behaviour Functions 
 * ----------------------------------------------------------------- */

CLI b_errtype EXPORT BestPowerUpPropSet(                            /* @puprpset */
          b_handletype handle,
          b_puproptype pu_prop,       /* @prop */
          b_int32      value          /* @val  */
          );


CLI b_errtype EXPORT BestPowerUpPropGet(                            /* @puprpget */
          b_handletype handle,
          b_puproptype pu_prop,       /* @prop */
          b_int32      *value         /* #RETURN "propery value: %08lx\\h\n" */
          );


CLI b_errtype EXPORT BestPowerUpPropDefaultSet (          /* @puprpdefset */
            b_handletype  handle
          );


CLI b_errtype EXPORT BestAllPropStore(                          /* @aprpstore */
          b_handletype   handle
          );


CLI b_errtype EXPORT BestAllPropLoad(                           /* @aprpload */
               b_handletype   handle
               );


CLI b_errtype EXPORT BestAllPropDefaultLoad(                    /* @aprpdefload */
                b_handletype handle
                );



/* -----------------------------------------------------------------
 * Miscellaneous Functions 
 * ----------------------------------------------------------------- */
 
CLI b_errtype  EXPORT BestSMReset(                                /* @smreset */
         b_handletype handle 
         );


CLI b_errtype  EXPORT BestBoardReset(                              /*  @bdreset  */    
             b_handletype handle
             );


CLI b_errtype EXPORT BestBoardRestart (         /* @restart */
          b_handletype handle
        );

CLI b_errtype EXPORT BestCapiPropSet(                             /* @capiprpset */
              b_handletype    handle,
              b_capiproptype boardprop,   /* @prop */
              b_int32         value       /* @val */
              );


CLI b_errtype EXPORT BestCapiPropGet(                             /* @capiprpget */
              b_handletype    handle,
              b_capiproptype capiprop,   /* @prop */
                    b_int32         *value      /* #RETURN "Boardproperty =: %x\\h\n" */
              );

CLI b_errtype EXPORT BestVersionGet(           /* @vget */
            b_handletype      handle,
            b_versionproptype versionprop, /* @prop */
            b_charptrtype     *string      /* #RETURN "Versionproperty =: %s\n" */
            );


/* Exerciser functions */
CLI b_errtype EXPORT BestExerciserGenPropGet(                        /* @egprpget */
                                        b_handletype  handle,
                                        b_exercisergenproptype exeprop,       /* @prop */
                                        b_int32       *value          /* #RETURN "property value: %08lx\\h" */
                                        );


CLI b_errtype EXPORT BestExerciserGenPropSet(                        /* @egprpset */
               b_handletype  handle,
               b_exercisergenproptype exeprop, /* @prop */
               b_int32       value     /* @val */
             );


#ifdef __cplusplus
}
#endif


#endif






